///////////////////////////////////////////////////////////////////////////////////
//No part of this file can be copied or released without the consent of 
//Avalanche Technology
//										
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
//										
//	Avalanche Technology Inc., Proprietary and Confidential	   *
//										
// 	Release:  2.1    Date 11/29/2023  	
//							
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//  PART DESCRIPTION:
//
//  Technology: 22nm pMTJ STT-MRAM
//  Part:       AS30XGB32
//
//  Description: 1 Gigabit PARALLEL PERSISTANT SRAM MEMORY
//
////////////////////////////////////////////////////////////////////////////////////
//  FILE CONTENTS : MODEL OF PPSRAM 
//
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// TASKS DECLARATION                                                             //
////////////////////////////////////////////////////////////////////////////////////

//`timescale 1ns/1ps

////////////////////////////////////////////////////////////////////
// Datasheet Timing
////////////////////////////////////////////////////////////////////
specify
   specparam tSLE = 5000;
   specparam tSLEX = 5000;
   specparam tAVWL = 8;
   specparam tWLWH = 25;
   specparam tDVWH = 15;
   specparam tWHAX = 15;
   specparam tELQX = 15; 
   specparam tGLQX = 0; 
   specparam tGLQV = 25; 
   specparam tEHQZ = 5; 
   specparam tPGSL = 10; 
   specparam tPGSH = 10; 
   specparam tASP = 7.5; 
   specparam tWP = 7.5; 
   specparam tPWC = 15; 
   specparam tOHP = 5; 
   specparam tAAP = 15; 
endspecify

////////////////////////////////////////////////////////////////////
//Signals Enable/Disable
////////////////////////////////////////////////////////////////////
task SelectChip;
begin
      En = 0;
end
endtask


task DeSelChip;
begin
      En = 1;
      #5;
end
endtask


task WriteEnable;
begin
      Wn = 0;
end
endtask


task WriteDisable;
begin
      Wn = 1;
end
endtask

task OutputEnable;
begin
      Gn = 0;
end
endtask 


task OutputDisable;
begin
      Gn = 1;
end
endtask

task PageEnable;
begin
      PGn = 0;
end
endtask 

task PageDisable;
begin
      PGn = 1;
end
endtask

task ConfigEnable;
begin
      CRn = 0;
end
endtask


task ConfigDisable;
begin
      CRn = 1;
end
endtask

////////////////////////////////////////////////////////////////////
// Send Address
////////////////////////////////////////////////////////////////////
task SendAdd;
input bit [20:0] addr;

begin
      ADDR = addr;
end
endtask


////////////////////////////////////////////////////////////////////
// Send and Receive Data
////////////////////////////////////////////////////////////////////
task SendDataWord;
input bit [31:0] data;
begin
      out_en = 1;
      DQ_reg = data;
end
endtask

task RcvDataWord;
output [31:0] data;
begin
      out_en = 0;
      DQ_reg = 32'hz;
      data = DQ;
end
endtask

////////////////////////////////////////////////////////////////////
// WRITE
////////////////////////////////////////////////////////////////////
task Write;
input bit [19:0] addr;
input bit [31:0] data;


begin

//   parameter CE_WRITE = 0;

   if( CE_WRITE == 1)
	SelectChip();

   SendAdd(addr);
   OutputDisable();
   #(tAVWL);
   WriteEnable();
   SendDataWord(data);
   #(tWLWH);

   WriteDisable();
   #tWHAX;

   if( CE_WRITE == 1)
	DeSelChip();

   out_en = 0;
end
endtask

////////////////////////////////////////////////////////////////////
// READ
////////////////////////////////////////////////////////////////////
task Read;
input bit [19:0] addr;
input bit [31:0] data;

reg [31:0] data_rcv;

begin

//   parameter CE_READ = 0;
//   parameter ADR_READ = 0;

   if( CE_READ == 1)
	SelectChip();
   else if (ADR_READ == 1)
         OutputEnable();

   SendAdd(addr);
   WriteDisable();
   #(tELQX-tGLQX);
   OutputEnable();


   #(tGLQV+6);
   RcvDataWord(data_rcv);

   #(tEHQZ);
   if (ADR_READ == 1)
   	OutputDisable();

   if( CE_READ == 1)
	DeSelChip();
   
   #5;

   if(data_rcv !== data)
       $display("[ERROR] Mem Read Compare Error: Expected %x Received %x",data,data_rcv);
   else
       $display("[INFO] Mem Read Compare Pass: Expected %x Received %x",data,data_rcv);

end
endtask

////////////////////////////////////////////////////////////////////
// Config Enter
////////////////////////////////////////////////////////////////////
task ConfigEnter;
begin

   ConfigEnable();
   SelectChip();
   CE_WRITE = 0;
   CE_READ = 0;
   Write('h33,'haa);
   Write('h0c,'haa);
   Write('h4a,'haa);

end
endtask

////////////////////////////////////////////////////////////////////
// Config Enter
////////////////////////////////////////////////////////////////////
task ConfigExit;
begin

   DeSelChip();
   #5;
   ConfigDisable();
   CE_WRITE = 1;
   CE_READ = 1;
end
endtask




////////////////////////////////////////////////////////////////////
// PAGE WRITE
////////////////////////////////////////////////////////////////////
task PGWriteSeq;
input bit [19:0] addr;
input bit [31:0] data;
input integer data_add;

integer n;
begin

//   parameter CE_WRITE = 0;
   PageEnable();
   #tPGSL;
   SelectChip();
   CE_WRITE=0;
   Write(addr,data);
   #10;
   
   for(n=1;n<4;n++)
   begin
   WriteEnable();
   #(tWP-tASP)
   SendAdd(addr+n);
   SendDataWord(data+(data_add*n));
   #tASP;
   WriteDisable();
   #(tPWC-tWP);
   end

   PageDisable();
   DeSelChip();
   #tPGSH;

   out_en = 0;
   CE_WRITE = 1;
end
endtask

////////////////////////////////////////////////////////////////////
// PAGE READ
////////////////////////////////////////////////////////////////////
task PGReadSeq;
input bit [19:0] addr;
input bit [31:0] data;
input integer data_add;
input integer num_read;
input bit new_timing;

reg [31:0] data_rcv;
bit [19:0] n;
reg [19:0] addr_ch;

begin

//   parameter CE_READ = 0;
//   parameter ADR_READ = 0;

   addr_ch = addr;

   PageEnable();
   #tPGSL;
   SelectChip();
   CE_READ = 0;
   ADR_READ = 0;
   Read(addr,data);

   for(n=1;n<num_read;n++)
   begin

   if(new_timing) begin
      if(n[1:0] == 2)
        addr_ch[19:2]++;

      if(n[1:0] == 0)
        addr_ch[1:0] = 0;
      else
        addr_ch[1:0]++;
   end
   else begin
      addr_ch = addr+n;
   end

   //SendAdd(addr+n);
   SendAdd(addr_ch);
   #(tAAP+1);
   RcvDataWord(data_rcv);

   #(tOHP);

   if(data_rcv !== data+(data_add*n))
       $display("[ERROR] Mem Read Compare Error: Expected %x Received %x",data+(data_add*n),data_rcv);
   else
       $display("[INFO] Mem Read Compare Pass: Expected %x Received %x",data+(data_add*n),data_rcv);

   end

   OutputDisable();
   DeSelChip();
   PageDisable();
   CE_READ = 1;
   ADR_READ = 1;

end
endtask




////////////////////////////////////////////////////////////////////
// WRITE READ CHECK
////////////////////////////////////////////////////////////////////
task WriteReadCheck();
begin
   $display("*****************************************");
   $display(" Write Read Word Check");
   $display("*****************************************");


   SelectChip();
   Write(21'h01,32'ha864a864);
   Write(21'h02,32'h95109510);
   Write(21'h03,32'h47c447c4);
   Write(21'h04,32'hfe89fe89);
   Write(21'h05,32'h147a147a);
   Write(21'h06,32'hce83ce83);
   DeSelChip();


   SelectChip();
   Read(21'h01,32'ha864a864);
   Read(21'h02,32'h95109510);
   Read(21'h03,32'h47c447c4);
   Read(21'h04,32'hfe89fe89);
   Read(21'h05,32'h147a147a);
   Read(21'h06,32'hce83ce83);
   DeSelChip();

end
endtask





